let version = 'v1';
let offlineCacheKey = 'offline-' + version;
const OFFLINE_URL = 'offline.html';

self.addEventListener('install', event => {
  console.log('[SW] installing ' + version + '...');

  event.waitUntil(
    caches.open(offlineCacheKey).then(
      cache => {
        console.log('[SW] cache ' + offlineCacheKey + ' created');
        cache.add(OFFLINE_URL);
      }
    )
  );

  event.waitUntil(
    caches.keys().then(keys => Promise.all(
      keys.map(key => {
        if (key.indexOf(version) < 0) {
          console.log('[SW] delete old cache: ' + key);
          caches.delete(key);
        }
      })
    )).then(() => {
      console.log('[SW] ' + version + ' ready');
    })
  );
});


self.addEventListener('activate', _event => {
  console.log('[SW] ' + version + ' activated');
});

// self.addEventListener("fetch", event => {
//   if (event.request.mode === "navigate") {
//     return event.respondWith(
//       fetch(event.request).catch(
//         () => caches.match(OFFLINE_URL)
//       )
//     );
//   }
// });
